//
//  MCRolloverMenuButton.h
//  MCApplication
//
//  Created by Ali Lalani on 8/20/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface MCRolloverMenuButton : NSView {
	NSTextAlignment textAlignment;
	
	// Action and Target
	SEL action;
	id target;

	// Misc Objects
	NSMenu *menu;
	NSString *title;
	NSImage *displayImage;
	NSImage *mouseDownDisplayImage;
	NSDictionary *displayStringAttributes;
	NSDictionary *onDisplayStringAttributes;
	
	id _representedObject;
	id dragDelegate;
	
	// Colors
	NSColor *rolloverColor;  // bgColor for when the mouse rolls over 
	NSColor *mouseDownColor; // bgColor for when the mouse button is pressed
	NSColor *onColor; // bgColor for a stateful button if it is on(selected)
	NSColor *offColor; // bgColor in its natural state
	NSColor *displayStringColor;

	// primitives
	float curveRadius; // how curvy the edges are
	float marginWidth; // how much empty space on the left and right before the text starts and (for the triangle as well) after it ends
	float displayStringYOffset; // move the Y value of the drawpoint by this much(since i can't figure out how to make any font centered)
	float maxWidth; // maximum width the button can be, so contrain to this even if the title is longer!
	BOOL isOn;         // if stateful, this tells us if it is on or off(selected vs. unselected)
	BOOL showTriangleForMenu; // if it has a menu, this will tell us if we have to draw the triangle at the right
	BOOL mouseIsOver;         // if the mouse is over or not
	BOOL isStateful;          // if it is an on/off button
	BOOL mouseIsDown;
	BOOL hasContextualMenu;
	int tag;                  // for identifying the widget

	// Tracking Rect
	NSTrackingRectTag rolloverTrackingRectTag;

	// Rects
	NSRect displayStringRect;
	NSRect triangleRect;
	
	// Points
	NSPoint displayStringDrawPoint;
}

///////////////// DRAWING //////////////////
- (void)recalculateRects;
- (float)preferredWidth;

///////////////// TRACKING RECT ////////////
- (void)clearTrackingRect;
- (void)resetTrackingRects;

///////////////// MENU /////////////////////
- (void)showMenu;

///////////////// ACCESSORS ////////////////
- (NSMenu *)menu;
- (void)setMenu:(NSMenu *)aMenu;

- (BOOL)hasContextualMenu;
- (void)setHasContextualMenu:(BOOL)flag;

- (id)representedObject;
- (void)setRepresentedObject:(id)anObj;

- (NSColor *)rolloverColor;
- (void)setRolloverColor:(NSColor *)aRolloverColor;

- (NSColor *)mouseDownColor;
- (void)setMouseDownColor:(NSColor *)aMouseDownColor;

- (NSColor *)onColor;
- (void)setOnColor:(NSColor *)anOnColor;

- (NSColor *)offColor;
- (void)setOffColor:(NSColor *)anOffColor;

- (float)curveRadius;
- (void)setCurveRadius:(float)aCurveRadius;

- (BOOL)showTriangleForMenu;
- (void)setShowTriangleForMenu:(BOOL)flag;

- (BOOL)isStateful;
- (void)setIsStateful:(BOOL)flag;

- (NSColor *)displayStringColor;
- (void)setDisplayStringColor:(NSColor *)aDisplayStringColor;

- (NSImage *)displayImage;
- (void)setDisplayImage:(NSImage *)aDisplayImage;

- (NSImage *)mouseDownDisplayImage;
- (void)setMouseDownDisplayImage:(NSImage *)aMouseDownDisplayImage;

- (NSDictionary *)displayStringAttributes;
- (void)setDisplayStringAttributes:(NSDictionary *)aDisplayStringAttributes;

- (SEL)action;
- (void)setAction:(SEL)anAction;

- (id)target;
- (void)setTarget:(id)aTarget;

- (int)tag;
- (void)setTag:(int)aTag;

- (float)marginWidth;
- (void)setMarginWidth:(float)aMarginWidth;

- (void)setState:(int)flag;
- (int)state;

- (id)dragDelegate;
- (void)setDragDelegate:(id)aDragDelegate;

- (NSDictionary *)onDisplayStringAttributes;
- (void)setOnDisplayStringAttributes:(NSDictionary *)anOnDisplayStringAttributes;

- (NSString *)title;
- (void)setTitle:(NSString *)aTitle;

- (float)displayStringYOffset;
- (void)setDisplayStringYOffset:(float)aDisplayStringYOffset;

- (float)maxWidth;
- (void)setMaxWidth:(float)aMaxWidth;
@end

@interface NSObject (MCRolloverMenuButtonDragDelegate)
- (BOOL)beginDragForButton:(MCRolloverMenuButton *)aButton event:(NSEvent *)theEvent dragImage:(NSImage *)anImage;
@end

@interface NSObject (MCRolloverMenuButtonContextualMenuDelegate)
- (NSMenu *)contextualMenuForButton:(MCRolloverMenuButton *)sender;
@end
